#pragma once

#include "../common.h"
#include "../topology_data.h"
#include "segments/segments_graph.h"
#include "segments/segments_overlapper.h"
#include "topology_data_proxy.h"
#include "edges_fixer.h"

#include <maps/libs/geolib/include/point.h>
#include <maps/libs/geolib/include/segment.h>

#include <boost/optional.hpp>

#include <list>
#include <unordered_map>
#include <thread>

namespace maps {
namespace wiki {
namespace topology_fixer {
namespace utils {

class EdgesOverlapsFixer : public EdgesFixer {
public:
    EdgesOverlapsFixer(
            TopologyDataProxy& data,
            FaceLocker& locker,
            double tolerance,
            double maxAngleBetweenSegments)
        : EdgesFixer(data, locker, tolerance)
        , name_("OverlapsFixer")
        , tolerance_(tolerance)
        , maxAngleBetweenSegments_(maxAngleBetweenSegments)
    {}

    const std::string& name() const override { return name_; }

private:
    class ProcessingData : public EdgesFixer::ProcessingData {
    public:
        ProcessingData(
                EdgeId edgeId1, EdgeId edgeId2,
                TopologyDataProxy& data,
                FaceLocker& locker,
                double tolerance,
                double maxAngleBetweenSegments)
            : EdgesFixer::ProcessingData(edgeId1, edgeId2, data, locker)
            , tolerance_(tolerance)
            , maxAngleBetweenSegments_(maxAngleBetweenSegments)
        {}

        virtual SegmentsProcessingResult processEdges();

        /**
         * Edges touching is not allowed 'cause it results in touching polygons.
         * => all newly shared points must have at least one incident shared edge.
         */
        virtual bool newNodesValid() const;

        virtual bool restoreTopologyInCopy();

    protected:
        void collapseZeroLengthSegments(EdgeId edgeId, SegmentIdsList& segmentIds);

        double tolerance_;
        double maxAngleBetweenSegments_;
    };

    std::unique_ptr<EdgesFixer::ProcessingData>
    initProcessingData(EdgeId edgeId1, EdgeId edgeId2) override;

    /**
     * Edges overlaps can be processed if
     *  1) all edge endpoints have the same zlevel
     *  2) edges have no common master (in this case faces restoration becomes
     *    far too complicated)
     */
    bool edgesFixingAllowed(EdgeId edgeId1, EdgeId edgeId2) const override;

    std::string name_;
    double tolerance_;
    double maxAngleBetweenSegments_;
};

} // namespace utils
} // namespace topology_fixer
} // namespace wiki
} // namespace maps
