#include "face_validator.h"

#include <maps/libs/geolib/include/polygon.h>

namespace maps {
namespace wiki {
namespace topology_fixer {

void validateFaces(const TopologyData& data)
{
    INFO() << "Face validation";

    size_t count = 0;

    for (auto faceId : data.faceIds()) {
        try {
            geolib3::Polygon2(data.faceVertices(faceId));
        } catch (const std::exception& e) {
            WARN() << "Face " << faceId << " has invalid geometry: " << e.what();
            count++;
        }
    }

    INFO() << "Face validation: [Done] error count " << count;
}

} // namespace topology_fixer
} // namespace wiki
} // namespace maps
