#pragma once

#include "../common.h"
#include "../topology_data.h"

#include <maps/libs/geolib/include/point.h>
#include <maps/libs/geolib/include/polyline.h>
#include <maps/libs/geolib/include/vector.h>
#include <maps/libs/geolib/include/static_geometry_searcher.h>

#include <unordered_map>

namespace maps {
namespace wiki {
namespace topology_fixer {

class TopologyData;

template <class Geom> Geom geomFromWkb(const std::string& wkb, SRID srid);

template <class Geom> std::string geomToWkb(const Geom& geom, SRID srid);


double angle(const geolib3::Line2& line, const geolib3::Line2& other);

/**
 * Adapted from
 *   wikimap/mapspro/services/tasks/validator-checks/utils/intersections_check.cpp
 */
bool
segmentsOverlap(
    const geolib3::Segment2& segment, const geolib3::Segment2& other,
    double eps, double maxAngle);


bool isSimple(const geolib3::PointsVector& points, bool requiredToBeClosed,
    bool silent = false);

double signedArea(const geolib3::PointsVector& points);

double perimeter(const geolib3::PointsVector& points);
double perimeter(const geolib3::Polyline2& polyline);

struct PlainEdgeData
{
    NodeId fnodeId;
    NodeId tnodeId;
    const geolib3::PointsVector& points;
};

typedef std::unordered_map<EdgeId, PlainEdgeData> PlainEdgesData;

geolib3::PointsVector buildPolygon(FaceId faceId, const PlainEdgesData& edgesData);

bool isCycleOrCircuit(const TopologyData& data, const IdSet& edgeIds,
    NodeId fnodeId, NodeId tnodeId);


bool
isNodesMergingAllowed(const TopologyData& data,
    NodeId toLeaveId, NodeId toRemoveId,
    double maxRemovableEdgeLength);

bool
isEdgeGeometryAllowed(const TopologyData& data, EdgeId edgeId,
    const geolib3::PointsVector& newGeom);


bool
areFacesSame(
    FaceId faceId1, const geolib3::PointsVector& points1,
    FaceId faceId2, const geolib3::PointsVector& points2,
    double tolerance,
    double maxAngleBetweenSegments,
    double maxTranslationFactor,
    double maxAPRatioFactor);

} // namespace topology_fixer
} // namespace wiki
} // namespace maps
