#pragma once

#include "../common.h"
#include "../topology_data.h"
#include "segments/segments_graph.h"
#include "segments/segments_overlapper.h"
#include "topology_data_proxy.h"
#include "edges_fixer.h"

#include <maps/libs/geolib/include/point.h>
#include <maps/libs/geolib/include/segment.h>

#include <boost/optional.hpp>

#include <list>
#include <unordered_map>
#include <thread>

namespace maps {
namespace wiki {
namespace topology_fixer {
namespace utils {

class LinearEdgesIntersectionsFixer : public EdgesFixer {
public:
    struct Params {
        double overlapTolerance;
        double maxAngleBetweenOverlappingSegments;
        double minSegmentLength;
        double maxSnapDistance;
        double snapTolerance;
    };

    LinearEdgesIntersectionsFixer(
            TopologyDataProxy& data,
            FaceLocker& locker,
            const Params& params)
        : EdgesFixer(data, locker, std::max(params.overlapTolerance, params.maxSnapDistance))
        , name_("LinearIntersectionsFixer")
        , params_(params)
    {}

    virtual const std::string& name() const { return name_; }

private:
    class ProcessingData : public EdgesFixer::ProcessingData {
    public:
        ProcessingData(
                EdgeId edgeId1, EdgeId edgeId2,
                TopologyDataProxy& data,
                FaceLocker& locker,
                const Params& params)
            : EdgesFixer::ProcessingData(edgeId1, edgeId2, data, locker)
            , params_(params)
        {}

        virtual SegmentsProcessingResult processEdges();

        virtual bool newNodesValid() const;
        virtual void createNewNodes();
        virtual bool restoreTopologyInCopy();

    protected:
        Params params_;
    };

    virtual std::unique_ptr<EdgesFixer::ProcessingData>
    initProcessingData(EdgeId edgeId1, EdgeId edgeId2);

    std::string name_;
    Params params_;
};

} // namespace utils
} // namespace topology_fixer
} // namespace wiki
} // namespace maps
