#pragma once

#include "segments_graph.h"
#include "segments_processing_common.h"

namespace maps {
namespace wiki {
namespace topology_fixer {
namespace utils {

class SegmentsPairEndpointsSnapper {
public:
    SegmentsPairEndpointsSnapper(
            double maxSnapDistance,
            double tolerance)
        : maxSnapDistance_(maxSnapDistance)
        , tolerance_(tolerance)
    {}

    SegmentsProcessingResult
    operator () (
        SegmentsGraph& graph, SegmentId segmentId1, SegmentId segmentId2) const;

private:
    double maxSnapDistance_;
    double tolerance_;
};

class SegmentEndpointsSnapper : public SegmentsProcessor {
public:
    SegmentEndpointsSnapper(
            double maxSnapDistance,
            double tolerance)
        : SegmentsProcessor(
              SegmentsPairEndpointsSnapper(maxSnapDistance, tolerance))
        , maxSnapDistance_(maxSnapDistance)
        , tolerance_(tolerance)
    {}

protected:

    class Impl : public SegmentsProcessor::Impl {
    public:
        Impl(
                const SegmentsPairProcessor& processor,
                SegmentsGraph& graph,
                const SegmentIdsList& segmentIds,
                const SegmentIdsList& otherSegmentIds,
                double maxSnapDistance,
                double tolerance)
            : SegmentsProcessor::Impl(processor, graph, segmentIds, otherSegmentIds)
            , maxSnapDistance_(maxSnapDistance)
            , tolerance_(tolerance)
        {}

        virtual SegmentsProcessingResult doProcessing()
        {
            return processAllInteractions();
        }

        virtual void doAfterProcessing();

    protected:
        double maxSnapDistance_;
        double tolerance_;
    };

    virtual std::unique_ptr<SegmentsProcessor::Impl>
    initImpl(
        SegmentsGraph& graph,
        const SegmentIdsList& segmentIds,
        const SegmentIdsList& otherSegmentIds) const
    {
        return std::unique_ptr<Impl>(new Impl(
            processor_, graph, segmentIds, otherSegmentIds,
            maxSnapDistance_, tolerance_));
    }

    double maxSnapDistance_;
    double tolerance_;
};

SegmentsProcessingResult
processSnappingPoints(SegmentsGraph& data,
    const SegmentIdsList& segmentIds, const SegmentIdsList& otherSegmentIds,
    double maxSnapDistance, double tolerance);

} // namespace utils
} // namespace topology_fixer
} // namespace wiki
} // namespace maps
