#pragma once

#include "segments_graph.h"
#include "segments_processing_common.h"

namespace maps {
namespace wiki {
namespace topology_fixer {
namespace utils {

class SegmentsPairIntersector {
public:
    explicit SegmentsPairIntersector()
    {}

    SegmentsProcessingResult
    operator () (
        SegmentsGraph& graph, SegmentId segmentId1, SegmentId segmentId2) const;
};

class SegmentsIntersector : public SegmentsProcessor {
public:
    explicit SegmentsIntersector()
        : SegmentsProcessor(SegmentsPairIntersector())
    {}

protected:

    class Impl : public SegmentsProcessor::Impl {
    public:
        Impl(
                const SegmentsPairProcessor& processor,
                SegmentsGraph& graph,
                const SegmentIdsList& segmentIds,
                const SegmentIdsList& otherSegmentIds)
            : SegmentsProcessor::Impl(processor, graph, segmentIds, otherSegmentIds)
        {}

        virtual SegmentsProcessingResult doProcessing()
        {
            return processAllInteractions();
        }

        virtual void doAfterProcessing();
    };

    virtual std::unique_ptr<SegmentsProcessor::Impl>
    initImpl(
        SegmentsGraph& graph,
        const SegmentIdsList& segmentIds,
        const SegmentIdsList& otherSegmentIds) const
    {
        return std::unique_ptr<Impl>(new Impl(
            processor_, graph, segmentIds, otherSegmentIds));
    }
};

SegmentsProcessingResult
processIntersections(SegmentsGraph& data,
    const SegmentIdsList& segmentIds, const SegmentIdsList& otherSegmentIds);

} // namespace utils
} // namespace topology_fixer
} // namespace wiki
} // namespace maps
