#pragma once

#include "segments_graph.h"

#include <functional>

namespace maps {
namespace wiki {
namespace topology_fixer {
namespace utils {

struct SegmentsProcessingResult {
    SegmentIdsList segmentIds1;
    SegmentIdsList segmentIds2;
    bool hasChanges;
};

class SegmentsProcessor {
public:
    typedef
        std::function<
            SegmentsProcessingResult(SegmentsGraph&, SegmentId, SegmentId)>
        SegmentsPairProcessor;

    SegmentsProcessingResult operator () (
        SegmentsGraph& graph,
        const SegmentIdsList& segmentIds,
        const SegmentIdsList& otherSegmentIds) const;

    virtual ~SegmentsProcessor() {}

protected:
    explicit SegmentsProcessor(
            const SegmentsPairProcessor& processor)
        : processor_(processor)
    {}

    class Impl {
    public:
        Impl(
                const SegmentsPairProcessor& processor,
                SegmentsGraph& graph,
                const SegmentIdsList& segmentIds,
                const SegmentIdsList& otherSegmentIds)
            : processor_(processor)
            , graph_(graph)
            , segmentIds_(segmentIds)
            , otherSegmentIds_(otherSegmentIds)
        {}

        virtual ~Impl() {}

        virtual void doBeforeProcessing() {}

        virtual SegmentsProcessingResult doProcessing() = 0;

        virtual void doAfterProcessing() {}


        SegmentsProcessingResult processAllInteractions();

        SegmentsProcessingResult processInteractionsOnce();


        void removeDuplicatedSegments();

        void removeSnags();

    protected:
        const SegmentsPairProcessor& processor_;
        SegmentsGraph& graph_;
        SegmentIdsList segmentIds_;
        SegmentIdsList otherSegmentIds_;
    };

    virtual std::unique_ptr<Impl>
    initImpl(
        SegmentsGraph& graph,
        const SegmentIdsList& segmentIds,
        const SegmentIdsList& otherSegmentIds) const = 0;

    SegmentsPairProcessor processor_;
};

} // namespace utils
} // namespace topology_fixer
} // namespace wiki
} // namespace maps
