#pragma once

#include "../common.h"
#include "../topology_data.h"
#include "sync.h"

#include <memory>

namespace maps {
namespace wiki {
namespace topology_fixer {

namespace utils {

class TopologyDataProxy;

} // namespace utils

/**
 * Deep copy topology starting from given edges. First select all faces
 *  connected to edges, then hierarchically copy all dependent objects.
 */
std::unique_ptr<TopologyData>
copyByEdges(const TopologyData& data, FaceLocker& locker, const IdSet& edgeIds);

std::unique_ptr<TopologyData>
copyByEdges(utils::TopologyDataProxy& data, FaceLocker& locker, const IdSet& edgeIds);

struct ObjectIds {
    IdSet nodeIds;
    IdSet edgeIds;
    IdSet faceIds;
    IdSet masterIds;
    std::vector<FaceEdgeData> faceEdgeRelations;
    std::vector<EdgeMasterData> edgeMasterRelations;
    std::vector<FaceMasterData> faceMasterRelations;
};

struct TopologyDataDiff {
    ObjectIds added;
    ObjectIds deleted;
};

TopologyDataDiff
computeDiff(const TopologyData& data, const TopologyData& other);

void
applyDiff(TopologyData& data, const TopologyData& other,
    const TopologyDataDiff& diff);

void
applyDiff(utils::TopologyDataProxy& data, const TopologyData& other,
    const TopologyDataDiff& diff);

} // namespace topology_fixer
} // namespace wiki
} // namespace maps
