#!/bin/sh -e

HOSTNAME="pg93mpro.maps.dev.yandex.net"
DBNAME="mapspro_production_ymapsdf"
PGUSER="mapspro"
PGPASSWORD="mapspro"
RESTRICTIONS_CONFIG_PATH="configs/restrictions.xml"

CONNSTR="host=$HOSTNAME port=5432 dbname=$DBNAME user=$PGUSER password=$PGPASSWORD"

INPUT_SCHEMA="ymapsdf_prealpha_yandex_russia_20140306"
OUTPUT_SCHEMA="ymapsdf_fixed"

#for GROUP in "ad" "vegetation" "hydro_contour" "hydro_ln" "relief" "urban" "urban_roadnet" "transport_railway"
for GROUP in "urban"
do
    ./topology_fixer --conn="$CONNSTR" \
        --input-schema=$INPUT_SCHEMA \
        --output-schema=$OUTPUT_SCHEMA \
        --start-ymapsdf-id=`./max_ymapsdf_id --conn="$CONNSTR" --schema=$OUTPUT_SCHEMA 2>/dev/null` \
        --group=$GROUP \
        --restrictions-config=$RESTRICTIONS_CONFIG_PATH \
        --srid=mercator \
        >log.russia2.$GROUP.pg93.log 2>&1
done
