#!/bin/sh

HOSTNAME="pg93mpro.maps.dev.yandex.net"
DBNAME="mapspro_production_ymapsdf"
PGUSER="mapspro"
PGPASSWORD="mapspro"
RESTRICTIONS_PATH="configs/restrictions.xml"

CONNSTR="host=$HOSTNAME port=5432 dbname=$DBNAME user=$PGUSER password=$PGPASSWORD"

INPUT_SCHEMA="ymapsdf_prealpha_yandex_russia_20140306"
OUTPUT_SCHEMA="ymapsdf_fixed"

#for GROUP in "ad" "vegetation" "hydro_contour" "hydro_ln" "relief" "urban" "urban_roadnet" "transport_railway"
for GROUP in "hydro_ln"
do
    ./faces_validator --conn="$CONNSTR" \
        --schema=$OUTPUT_SCHEMA \
        --group=$GROUP \
        --srid=mercator \
        >faces.russia2.$GROUP.pg93.log 2>&1

    ./edges_validator --conn="$CONNSTR" \
        --schema=$OUTPUT_SCHEMA \
        --group=$GROUP \
        --restrictions-config=$RESTRICTIONS_PATH \
        --srid=mercator \
        >edges.russia2.$GROUP.pg93.log 2>&1

    ./topology_checker --conn="$CONNSTR" \
        --original-schema=$INPUT_SCHEMA \
        --fixed-schema=$OUTPUT_SCHEMA \
        --group=$GROUP \
        --srid=mercator \
        --box-size=50000.0 \
        >checker.russia2.$GROUP.pg93.log 2>&1
done
