#include "geo_helpers.h"

#include <maps/libs/common/include/exception.h>
#include <maps/libs/geolib/include/conversion.h>
#include <maps/libs/geolib/include/serialization.h>
#include <maps/libs/geolib/include/vector.h>

#include <boost/algorithm/string.hpp>

namespace maps::wiki::traffic_analyzer {

geolib3::Point2 polylineMidPoint(const geolib3::Polyline2& polyline)
{
    REQUIRE(polyline.pointsNumber() >= 1,
        "Too few points in polyline to build its mid-point");

    auto beforeMid = polyline.pointAt((polyline.pointsNumber() - 1) / 2);
    auto afterMid  = polyline.pointAt(polyline.pointsNumber() / 2);

    return geolib3::Point2(
        (beforeMid.x() + afterMid.x()) / 2,
        (beforeMid.y() + afterMid.y()) / 2
    );
}

geolib3::Vector2 polylineGlobalDirection(const geolib3::Polyline2& polyline)
{
    const auto& points = polyline.points();
    REQUIRE(points.size() >= 2,
        "Too few points in polyline to build its direction");
    return points.back() - points.front();
}

geolib3::Polyline2 polylineMercFromRoadRev(
    const revision::ObjectRevision& roadRev)
{
    std::istringstream roadRevGeomStream(*roadRev.data().geometry);
    return geolib3::WKB::read<geolib3::Polyline2>(roadRevGeomStream);
}

} // namespace maps::wiki::traffic_analyzer
