#pragma once

#include <maps/libs/geolib/include/polyline.h>
#include <maps/libs/geolib/include/bounding_box.h>

namespace maps::wiki::traffic_analyzer {

/*
    Static graph edge has two kind of identificators - short id and long id.
    Long id is also called persistent id.
    Two-way road is splited on two different edges in graph -
    forward and backward, each of them has its own different identificators.

    Summarizing,
    TwoWayRoadIds contains all identificators of its edges:
    1) fwd  : short id of forward edge
    2) bkwd : short id of backward edge
    3) fwdPers  : long id of forward edge
    4) bkwdPers : long id of backward edge
*/
struct TwoWayRoadIds
{
    uint32_t fwd;
    uint32_t bkwd;
    uint64_t fwdPers;
    uint64_t bkwdPers;
};

struct GraphRoadInfo
{
    uint32_t funClass;
    geolib3::Polyline2 geomGeo;
};

class IGraph
{
public:
    virtual const std::string& version() const = 0;

    virtual GraphRoadInfo roadInfo(uint32_t roadId) const = 0;

    virtual std::vector<TwoWayRoadIds>
    getTwoWayRoads(const geolib3::BoundingBox& bboxGeo) const = 0;

    virtual ~IGraph() {}
};

} // namespace maps::wiki::traffic_analyzer
