#pragma once

#include "graph.h"
#include <yandex/maps/jams/spatial2/rtree.h>
#include <yandex/maps/jams/static_graph2/graph_data.h>
#include <yandex/maps/jams/static_graph2/persistent_index.h>
#include <yandex/maps/mms/holder2.h>


namespace maps::wiki::traffic_analyzer {

class GraphMmapped : public IGraph
{
    typedef jams::static_graph2::GraphData GraphData;
    typedef jams::spatial2::GraphEdgesRTree GraphEdgesRTree;
    typedef jams::static_graph2::PersistentIndex PersistentIndex;

public:
    GraphMmapped(const std::string& dataFile,
                 const std::string& edgesRtreeFile,
                 const std::string& persistentIndexFile);

    const std::string& version() const override;

    GraphRoadInfo roadInfo(uint32_t roadId) const override;

    std::vector<TwoWayRoadIds>
    getTwoWayRoads(const geolib3::BoundingBox& bboxGeo) const override;

private:
    std::string version_;
    mms::Holder2<GraphData> data_;
    mms::Holder2<GraphEdgesRTree> rtree_;
    PersistentIndex persistentIndex_;
};

} // namespace maps::wiki::traffic_analyzer
