#pragma once

#include "graph.h"
#include "hypotheses.h"
#include "revision_roads_miner.h"

#include <boost/optional.hpp>

namespace maps::wiki::traffic_analyzer {

/*
    Convert hypotheses, generated in terms of static road graph,
    into hypotheses in terms of Revision. It doesn't provide any
    proper (and sophisticated) mapping between Static Graph road id
    and Revision object & commit id. Mapping is built using roads geometry.
*/
class OnewayHypothesisConverter
{
public:
    OnewayHypothesisConverter(
        const IGraph& graph, std::unique_ptr<IRevisionRoadsMiner> revRoadsMiner);

    boost::optional<OnewayHypothesisRevision>
    convert(const OnewayHypothesisGraph& graphHyp) const;

private:
    const IGraph& graph_;
    std::unique_ptr<IRevisionRoadsMiner> revRoadsMiner_;
};

std::vector<OnewayHypothesisRevision>
convertHypsGraphToRevision(
    const std::vector<OnewayHypothesisGraph>& hypsGraph,
    const OnewayHypothesisConverter& conv);

} // namespace maps::wiki::traffic_analyzer
