#pragma once

#include "graph.h"
#include "hypotheses.h"
#include "hyp_params.h"
#include "road_id_tracks.h"

#include <vector>

namespace maps::wiki::traffic_analyzer {

/*
    Generates hypotheses if twoway road is actually oneway.
    Detailed description at:
    https://wiki.yandex-team.ru/users/shapds/onewayroadsdetectionusingtracks/
*/
class OnewayHypothesisGenerator
{
public:
    OnewayHypothesisGenerator(
        const IGraph& graph,
        PersIdToTracks persToTracks,
        const OnewayGenParams& params);

    std::vector<OnewayHypothesisGraph>
    generate(const std::vector<TwoWayRoadIds>& twoWayRoads);

private:
    const IGraph& graph_;
    PersIdToTracks persToTracks_;
    OnewayGenParams params_;
};

} // namespace maps::wiki::traffic_analyzer
