#include "hyp_params.h"
#include <maps/libs/common/include/exception.h>

namespace maps::wiki::traffic_analyzer {

OnewayGenParams::OnewayGenParams(
    double alarmMatchRatio,
    uint32_t maxFunclass,
    uint32_t minBothEdgeTracks) :
        alarmMatchRatio_(alarmMatchRatio),
        maxFunclass_(maxFunclass),
        minBothEdgeTracks_(minBothEdgeTracks)
{
    REQUIRE(0.5 <= alarmMatchRatio && alarmMatchRatio <= 1,
        "Alarm matched ratio is out of [0.5, 1] range");

    REQUIRE(maxFunclass <= 10, "Max fun-class is out of [0, 10] range");

    REQUIRE(minBothEdgeTracks > 0, "Minimal number of matched tracks " <<
        "on both edges of twoway road must be > 0");
}

double OnewayGenParams::alarmMatchRatio() const
{
    return alarmMatchRatio_;
}

uint32_t OnewayGenParams::maxFunclass() const
{
    return maxFunclass_;
}

uint32_t OnewayGenParams::minBothEdgeTracks() const
{
    return minBothEdgeTracks_;
}

} // namespace maps::wiki::traffic_analyzer
