#pragma once

#include <cstdint>

namespace maps::wiki::traffic_analyzer {

class OnewayGenParams
{
public:
    OnewayGenParams(
        double alarmMatchRatio,
        uint32_t maxFunclass,
        uint32_t minBothEdgeTracks);

    /*
       If match ratio (which is matched_tracks_fwd / matched_tracks_both) is
       larger than this number, this road is candidate for oneway hypothesis.
       Should be in interval (0, 1)
    */
    double alarmMatchRatio() const;

    /*
       Hypotheses will be generated for roads with fun-class
       less than or equal to this.
    */
    uint32_t maxFunclass() const;

    /*
       If number of matched tracks on both forward and backward edges
       of the road is less than this number, no hypothesis will be generated
       for the road.
    */
    uint32_t minBothEdgeTracks() const;

private:
    double alarmMatchRatio_;
    uint32_t maxFunclass_;
    uint32_t minBothEdgeTracks_;
};

} // namespace maps::wiki::traffic_analyzer
