#pragma once

#include "hypotheses.h"
#include <maps/libs/http/include/http.h>

namespace maps::wiki::traffic_analyzer {

class HypothesisRevisionPoster
{
public:
    HypothesisRevisionPoster(const std::string& socialServiceUrl);
    bool postHypothesis(const OnewayHypothesisRevision& hypRev) const;

private:
    http::URL socialServiceUrl_;
};

int postHypothesesLimited(
    const HypothesisRevisionPoster& poster,
    std::vector<OnewayHypothesisRevision> hyps,
    int hypsMaxNumber);

} // namespace maps::wiki::traffic_analyzer
