#pragma once

#include "hypotheses.h"
#include <maps/libs/json/include/builder.h>

namespace maps::wiki::traffic_analyzer {

void json(const RoadTraffic& roadTraf,
          json::ObjectBuilder builder);

std::string toJson(const RoadTraffic& roadTraf);

std::string toJson(const OnewayHypothesisGraph& hyp);

std::string toJson(const OnewayHypothesisRevision& hyp);

template<typename T>
T fromJson(const std::string& json);

template<>
RoadTraffic fromJson(const std::string& json);

template<>
OnewayHypothesisGraph fromJson(const std::string& json);

template<>
OnewayHypothesisRevision fromJson(const std::string& json);

} // namespace maps::wiki::traffic_analyzer
