#include "hypotheses.h"

namespace maps::wiki::traffic_analyzer {

RoadTraffic::RoadTraffic(
        uint32_t bothEdgeTracks_, double matchRatio_,
        std::string graphVersion_, boost::gregorian::date_period days_) :
    bothEdgeTracks(bothEdgeTracks_), matchRatio(matchRatio_),
    graphVersion(std::move(graphVersion_)), days(days_)
{
}

OnewayHypothesisGraph::OnewayHypothesisGraph(
        uint32_t roadId_, RoadTraffic roadTraffic_) :
    roadId(roadId_), roadTraffic(std::move(roadTraffic_))
{
}

OnewayHypothesisRevision::OnewayHypothesisRevision(
        const geolib3::Point2& positionMerc_, const revision::RevisionID& revId_,
        ymapsdf::rd::Direction direction_, RoadTraffic roadTraffic_) :
    positionMerc(positionMerc_), revId(revId_),
    direction(direction_), roadTraffic(std::move(roadTraffic_))
{
}

} // namespace maps::wiki::traffic_analyzer
