#pragma once

#include <maps/libs/geolib/include/point.h>
#include <maps/libs/json/include/builder.h>
#include <maps/libs/json/include/value.h>
#include <yandex/maps/wiki/revision/revisionid.h>

#include <maps/libs/ymapsdf/include/rd.h>

#include <boost/date_time/gregorian/gregorian.hpp>

namespace maps::wiki::traffic_analyzer {

/*
    Geometry of each road element is represented with polyline,
    which is vector of points, with start (A) and end (B).
    Direction of oneway road is stated wrt to A and B points.
    Ymapsdf correspondence:
    TwoWay = B
    FromAtoB = F
    FromBtoA = T
*/

struct RoadTraffic
{
    RoadTraffic(
            uint32_t bothEdgeTracks, double matchRatio,
            std::string graphVersion, boost::gregorian::date_period days);

    uint32_t bothEdgeTracks;
    double matchRatio;
    std::string graphVersion;
    boost::gregorian::date_period days;
};

struct OnewayHypothesisGraph
{
    OnewayHypothesisGraph(uint32_t roadId, RoadTraffic roadTraffic);

    uint32_t roadId;
    RoadTraffic roadTraffic;
};

struct OnewayHypothesisRevision
{
    OnewayHypothesisRevision(
        const geolib3::Point2& positionMerc,
        const revision::RevisionID& revId,
        ymapsdf::rd::Direction direction,
        RoadTraffic roadTraffic);

    geolib3::Point2 positionMerc;
    revision::RevisionID revId;
    ymapsdf::rd::Direction direction;
    RoadTraffic roadTraffic;
};

} // namespace maps::wiki::traffic_analyzer
