#pragma once

#include <yandex/maps/wiki/revision/revisionid.h>
#include <maps/libs/geolib/include/polyline.h>

namespace maps::wiki::traffic_analyzer {

class RevisionRoad
{
public:
    RevisionRoad(const revision::RevisionID& id, geolib3::Polyline2 geomMerc) :
        id_(id), geomMerc_(std::move(geomMerc))
    {}

    const revision::RevisionID& id() const { return id_; }
    const geolib3::Polyline2& geomMerc() const { return geomMerc_; }

private:
    revision::RevisionID id_;
    geolib3::Polyline2 geomMerc_;
};

} // namespace maps::wiki::traffic_analyzer
