#pragma once

#include <maps/libs/pgpool/include/pgpool3.h>
#include <yandex/maps/wiki/revision/revisionsgateway.h>
#include <yandex/maps/wiki/common/extended_xml_doc.h>
#include <yandex/maps/wiki/common/pgpool3_helpers.h>

namespace maps::wiki::traffic_analyzer {

class RevisionSnapshotHolder
{
public:
    RevisionSnapshotHolder(const common::ExtendedXmlDoc& revisionConfig) :
        poolHolder_(revisionConfig, "long-read", "long-read"),
        revTxnHandle_(poolHolder_.pool().slaveTransaction()),
        gateway_(revTxnHandle_.get()),
        revSnapshot_(gateway_.snapshot(gateway_.maxSnapshotId()))
    {}

    const revision::Snapshot& snapshot() const
    {
        return revSnapshot_;
    }

private:
    common::PoolHolder poolHolder_;
    pgpool3::TransactionHandle revTxnHandle_;
    revision::RevisionsGateway gateway_;
    revision::Snapshot revSnapshot_;
};

} // namespace maps::wiki::traffic_analyzer
