#include "road_id_tracks.h"

namespace maps::wiki::traffic_analyzer {

PersIdToTracks::PersIdToTracks(
        bg::date_period signalsPeriod,
        MapPersIdToTracks idToTrackNum) :
    signalsPeriod_(signalsPeriod),
    idToTrackNum_(std::move(idToTrackNum))
{
}

bg::date_period PersIdToTracks::signalsPeriod() const
{
    return signalsPeriod_;
}

uint32_t PersIdToTracks::tracksNum(uint64_t persId) const
{
    if (idToTrackNum_.count(persId)) {
        return idToTrackNum_.at(persId);
    } else {
        return 0;
    }
}

} // namespace maps::wiki::traffic_analyzer
