#pragma once

#include <boost/date_time/gregorian/gregorian.hpp>
#include <unordered_map>

typedef std::unordered_map<uint64_t, uint32_t> MapPersIdToTracks;

namespace maps::wiki::traffic_analyzer {

namespace bg = boost::gregorian;

/*
    Contains mapping from persistent id of road (in terms of static road graph)
    to number of matched tracks for given days period.
*/
class PersIdToTracks
{
public:
    PersIdToTracks(
        bg::date_period signalsPeriod,
        MapPersIdToTracks idToTrackNum);

    bg::date_period signalsPeriod() const;

    uint32_t tracksNum(uint64_t persId) const;

private:
    bg::date_period signalsPeriod_;
    MapPersIdToTracks idToTrackNum_;
};

} // namespace maps::wiki::traffic_analyzer
