#pragma once

#include "road_id_tracks.h"
#include <boost/date_time/gregorian/gregorian.hpp>

namespace maps::wiki::traffic_analyzer {

/*
    Returns mapping 'persistent_id of road -> number of matched tracks'
    for specified signals days period. Mapping is created through
    mapreduce operation for already matched tracks in jams workflow.
*/
PersIdToTracks getYTRoadsStat(boost::gregorian::date_period signalsPeriod);

/*
    Each day tracks are matched versus the most recent available
    version of graph. E.g. for the sequence:

    day:     2018-10-05 , 2018-10-06 , 2018-10-07 , 2018-10-08
    version: 18.10.04-0 , 18.10.04-0 , 18.10.08-0 , 18.10.10-1

    the result will be 18.10.04-0
*/
std::string
oldestGraphVersionOfMatchedTracks(
    boost::gregorian::date_period signalsPeriod);

/*
    Returns the latest matched signals day at YT.
*/
boost::gregorian::date latestMatchedSignalsDay();

} // namespace maps::wiki::traffic_analyzer
