#include "ad_geometry_builder.h"
#include "cmd_line_options.h"
#include "exit_codes.h"

#include <maps/libs/common/include/exception.h>
#include <maps/libs/log8/include/log8.h>

using namespace maps;
using namespace maps::wiki::ad_geometry_builder;

int main(int argc, char* argv[])
try {
    auto options = parseCommandLine(argc, argv);

    log8::setLevel(options.logLevel);

    INFO() << "Connection string: " << options.conn;
    INFO() << "Input schema: " << options.inSchema;
    INFO() << "Output schema: " << options.outSchema;
    INFO() << "Level kind: " << options.levelKind;
    DEBUG() << "Log level: " << options.logLevel;

    AdGeometryBuilder ad{
        options.conn,
        options.inSchema,
        options.outSchema
    };

    INFO() << "Geometry building is started.";
    ad.build(options.levelKind);
    INFO() << "Geometry building is finished.";

    INFO() << "Geometry check is started.";
    INFO() << "Perimeter tolerance: " << options.perimeterTolerance;
    ad.check(options.levelKind, options.perimeterTolerance);
    INFO() << "Geometry check is finished.";

    return EXITCODE_OK;
}
catch (const RuntimeError& e) {
    FATAL() << e.what();
    return EXITCODE_RUNTIME_ERROR;
}
