#pragma once

#include <pqxx/pqxx>
#include <string>

namespace maps {
namespace wiki {
namespace isocode {

class AdGeometryBuilder {
public:
    AdGeometryBuilder(
        pqxx::connection& conn,
        const std::string& inSchema,
        const std::string& outSchema);

    void build(size_t levelKind);
    void check(size_t levelKind, double perimeterTolerance);

private:
    pqxx::connection& conn_;
    std::string inSchema_;
    std::string outSchema_;

    std::string buildQuery(size_t levelKind) const;
    std::string checkQuery(size_t levelKind) const;
    std::string collectBordersQuery(size_t levelKind) const;

    bool isSchemaExist(const std::string& schema);
    bool isTableExist(const std::string& schema, const std::string& table);
};

} // namespace isocode
} // namespace wiki
} // namespace maps
