#include "coverage_builder.h"

#include <maps/libs/common/include/exception.h>
#include <maps/libs/log8/include/log8.h>

#include <yandex/maps/coverage5/builder.h>

#include <maps/libs/geolib/include/multipolygon.h>
#include <maps/libs/geolib/include/serialization.h>

#include <boost/filesystem.hpp>

#include <cstdint>

namespace fs = boost::filesystem;

namespace maps {
namespace wiki {
namespace isocode {

std::string
buildCoverageFile(
    pqxx::connection& conn,
    const std::string& schemaName,
    const std::string& tmpDir)
{
    std::string layer = "ymapsdf";
    std::string version = "1";
    fs::path file(tmpDir);
    file /= layer + ".mms." + version;
    INFO() << "Building coverage file: " << file.string();

    auto builder = coverage5::dataLayerBuilder(
        file.string(), layer, version, boost::none);

    auto query =
        "SELECT ad_id,isocode,ST_AsBinary(ST_Multi(ST_Buffer(shape,0.000002)))"
        " FROM " + schemaName + ".ad JOIN " + schemaName + ".ad_geom USING(ad_id)"
        " WHERE level_kind=1 AND g_ad_id IS NULL AND isocode IS NOT NULL";

    pqxx::work work(conn);
    auto rows = work.exec(query);
    INFO() << "ad size: " << rows.size();

    for (const auto& row : rows) {
        auto id = row[0].as<int64_t>(0);
        auto isocode = row[1].as<std::string>({});
        auto wkb = pqxx::binarystring(row[2]).str();

        try {
            std::istringstream rawStream(wkb);
            auto geoms = geolib3::WKB::read<geolib3::MultiPolygon2>(rawStream);
            DEBUG() << id << " : " << isocode << " polygons: " << geoms.polygonsNumber();

            builder->addRegion(id, boost::none, boost::none, std::string(isocode), {}, geoms);
        } catch (maps::Exception& e) {
            ERROR() << "invalid geometry, id: " << id << " isocode: " << isocode << " error: " << e;
        }
    }
    builder->build();
    INFO() << "Coverage file: " << file.string() << " builded";
    return file.string();
}

} // namespace isocode
} // namespace wiki
} // namespace maps
