#pragma once

#include <maps/libs/common/include/pimpl_utils.h>
#include <string>

namespace maps {
namespace wiki {
namespace isocode {

class GeometryProcessor
{
public:
    GeometryProcessor(
        const std::string& coverageFile,
        const std::string& connString,
        const std::string& schemaName);

    void processRdEl(size_t threads) const;
    void processRdJc(size_t threads) const;
    void processEdge(size_t threads) const;
    void processNode(size_t threads) const;

    NONCOPYABLE_PIMPL_DECLARATIONS(GeometryProcessor);
};

} // namespace isocode
} // namespace wiki
} // namespace maps
