#include "cmd_line_options.h"
#include "exit_codes.h"
#include "splitter.h"

#include <maps/libs/common/include/exception.h>
#include <maps/libs/log8/include/log8.h>

using namespace maps;
using namespace maps::wiki::ymapsdf_splitter;

int main(int argc, char* argv[])
try {
    auto options = parseCommandLine(argc, argv);

    log8::setLevel(options.logLevel);

    INFO() << "Connection string: " << options.conn;
    INFO() << "Input schema: " << options.inSchema;
    INFO() << "Output schema: " << options.outSchema;
    INFO() << "Threads number: " << options.threadsNumber;
    DEBUG() << "Log level: " << options.logLevel;

    Splitter {
        options.conn,
        options.inSchema,
        options.dryRun
    }
    .split(options.region, options.outSchema, options.threadsNumber);

    return EXITCODE_OK;
}
catch (const RuntimeError& e) {
    FATAL() << e.what();
    return EXITCODE_RUNTIME_ERROR;
}
