#include "parallel.h"

#include "helpers.h"

#include <maps/libs/common/include/exception.h>
#include <maps/libs/log8/include/log8.h>
#include <yandex/maps/wiki/threadutils/threadpool.h>

#include <pqxx/pqxx>

#include <exception>

namespace maps {
namespace wiki {
namespace ymapsdf_splitter {
namespace parallel {

void exec(
    const std::string& connStr,
    const Commands& commands,
    size_t threads,
    std::shared_ptr<std::atomic<bool>> fail,
    bool dryRun)
{
    ThreadPool pool(threads);
    for (const auto& command: commands) {
        pool.push(
            [&, command]
            {
                if (*fail) {
                    return;
                }

                INFO() << command.name << " has started";
                try {
                    ymapsdf_splitter::exec(connStr, command.query, dryRun, command.name);
                    INFO() << command.name << " has finished";
                } catch (const maps::RuntimeError& e) {
                    ERROR() << command.name << " has failed: " << e;
                    *fail = true;
                } catch (const std::exception& e) {
                    ERROR() << command.name << " has failed: " << e.what();
                    *fail = true;
                } catch (...) {
                    ERROR() << command.name << " has failed: unknown exception";
                    *fail = true;
                }
            }
        );
    }
    pool.shutdown();
}

} // namespace parallel
} // namespace ymapsdf_splitter
} // namespace wiki
} // namespace maps
