#pragma once

#include <atomic>
#include <memory>
#include <string>
#include <vector>

namespace maps {
namespace wiki {
namespace ymapsdf_splitter {
namespace parallel {

struct Command {
    std::string name;
    std::string query;
};

using Commands = std::vector<Command>;

void exec(
    const std::string& connStr,
    const Commands& commands,
    size_t threads,
    std::shared_ptr<std::atomic<bool>> fail,
    bool dryRun);

} // namespace parallel
} // namespace ymapsdf_splitter
} // namespace wiki
} // namespace maps
