#pragma once

#include "region.h"

#include <string>
#include <vector>

namespace maps {
namespace wiki {
namespace ymapsdf_splitter {

class Splitter {
public:
    Splitter(
        const std::string& connStr,
        const std::string& schema,
        bool dryRun);

    void split(const Region& region, const std::string& toSchema, size_t threadsNumber) const;

private:
    std::string connStr_;
    std::string schema_;
    bool dryRun_;

    bool isSchemaExist(const std::string& schema) const;
    void createSchema(const std::string& schema) const;

    void createTables(const std::string& schema) const;
    void createTable(const std::string& schema, const std::string& table) const;

    void copyTables(const std::string& toSchema) const;
    void copyTable(const std::string& table, const std::string& toSchema) const;

    void splitTables(const Region& region, const std::string& toSchema, size_t threadsNumber) const;
    std::string splitTableQuery(const std::string& table, const Region& region, const std::string& toSchema) const;

    void clearNonExistingParents(const std::string& toSchema) const;
};

} // namespace ymapsdf_splitter
} // namespace wiki
} // namespace maps
