#include "maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/common/params.h"
#include "maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib//common/data_error.h"
#include "maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/work/run.h"

#include <maps/libs/common/include/exception.h>
#include <yandex/maps/wiki/common/retry_duration.h>

#include <iostream>

using namespace maps;
using namespace maps::wiki;
using namespace maps::wiki::json2ymapsdf;

int main(int argc, char* argv[])
{
    try {
        Options options(argc, argv);
        if (options.needHelp()) {
            std::cerr << options.desc() << std::endl;
            return EXIT_FAILURE;
        }

        using namespace maps::wiki::common;
        RetryDurationPolicy::setDefaultDuration(std::chrono::hours(8));
        RetryDurationPolicy::setDefaultSleepTime(std::chrono::seconds(10));

        const auto& params = options.params();

        if (!params.printConfigurationFile.empty()) {
            printConfiguration(params);
        } else {
            tds2ymapsdf(params);
        }
        return EXIT_SUCCESS;
    } catch (const TdsDataError& ex) {
        ERROR() << ex.what();
    } catch (const maps::Exception& ex) {
        ERROR() << ex;
    } catch (const std::exception& ex) {
        ERROR() << ex.what();
    } catch (...) {
        ERROR() << "Unknown exception";
    }
    return EXIT_FAILURE;
}
