/* NMAPS-15553 Assign absent disputed views to AD alternative recognised by '001'*/

/* All disputed views. Should be updated in case of lib/locale changes */
CREATE TEMPORARY TABLE disputed_views (isocode varchar(3));
INSERT INTO disputed_views VALUES ('001'), ('UN'), ('UA'), ('RU'), ('TR'), ('IL'), ('AE');

/* Collect AD alternatives groups using g_ad_id key */
CREATE TEMPORARY TABLE ad_recognition_with_general_ad AS
SELECT
    ad_id,
    COALESCE(g_ad_id, ad_id) AS g_ad_id,
    ad_recognition.isocode
FROM ad_recognition JOIN ad USING (ad_id);

/* Collect default ('001') alternative AD for each group */
CREATE TEMPORARY TABLE default_ad_for_ad_group AS
SELECT
    g_ad_id,
    ad_id
FROM ad_recognition_with_general_ad
WHERE isocode = '001';

/* Collect absent views for each AD group */
CREATE TEMPORARY TABLE ad_group_without_some_recognition AS
SELECT DISTINCT ar.g_ad_id, dv.isocode
FROM ad_recognition_with_general_ad AS ar, disputed_views AS dv
EXCEPT
SELECT g_ad_id, isocode
FROM ad_recognition_with_general_ad;

/* Add default AD for absent views in each AD group */
INSERT INTO ad_recognition
SELECT ad_id, isocode
FROM ad_group_without_some_recognition
JOIN default_ad_for_ad_group USING(g_ad_id);
