CREATE TEMPORARY TABLE self_annotating_conds AS
    SELECT DISTINCT annotation_phrase_id as cond_id FROM cond_annotation_phrase_element e
        WHERE EXISTS
            (SELECT * FROM cond_annotation WHERE cond_id = e.annotation_phrase_id);
CREATE INDEX ON self_annotating_conds USING btree(cond_id);
UPDATE cond_annotation SET annotation_phrase_id = cond_id
    WHERE cond_id IN (SELECT cond_id FROM self_annotating_conds);
DROP TABLE self_annotating_conds;
