/* Adjust metro exit names according to direction of assigned passageways */

CREATE TEMPORARY TABLE transport_metro_exit_passageway
(
  exit_id bigint NOT NULL,
  passageway_id bigint NOT NULL
);
CREATE TEMPORARY TABLE operating_transport_metro_exit
(
  exit_id bigint NOT NULL,
  is_exit_only boolean NOT NULL,
  base_name text NOT NULL DEFAULT ''
);
CREATE TEMPORARY TABLE not_operating_transport_metro_exit
(
  exit_id bigint NOT NULL
);
CREATE TEMPORARY TABLE transport_metro_exit_without_render_label
(
  exit_id bigint NOT NULL
);

CREATE TEMPORARY SEQUENCE nm_id_serial;
SELECT SETVAL('nm_id_serial', MAX(nm_id)) FROM ft_nm;

/* Collect matches between exits and passageways */

INSERT INTO transport_metro_exit_passageway
SELECT DISTINCT ft_ft.slave_ft_id, ft_ft.master_ft_id
FROM ft_ft
JOIN ft AS master_ft ON (ft_ft.master_ft_id = master_ft.ft_id)
JOIN ft AS slave_ft ON (ft_ft.slave_ft_id = slave_ft.ft_id)
WHERE master_ft.ft_type_id = 2210 /* transport-metro-passageway */
  AND slave_ft.ft_type_id = 634 /* transport-metro-exit */;

/* Collect operating (according to linked passageways) exits */

WITH operating_transport_passageways AS (
  SELECT DISTINCT passageway_id FROM transport_metro_exit_passageway
  EXCEPT
  SELECT DISTINCT ft_id FROM ft_attr WHERE key = 'not_operating' AND value = '1'
)
INSERT INTO operating_transport_metro_exit
SELECT DISTINCT ON (exit_id) exit_id, (ft_attr.value = 'T') AS is_exit_only
FROM transport_metro_exit_passageway
JOIN ft_attr ON (passageway_id = ft_attr.ft_id)
JOIN operating_transport_passageways USING (passageway_id)
WHERE ft_attr.key = 'oneway'
ORDER BY exit_id, is_exit_only;

UPDATE operating_transport_metro_exit SET base_name = ' ' || name
FROM ft_nm
WHERE exit_id = ft_id AND name_type = 0 AND is_local;

/* Collect not-operating (according to linked passageways) exits */

INSERT INTO not_operating_transport_metro_exit
SELECT DISTINCT exit_id
FROM transport_metro_exit_passageway
EXCEPT
SELECT exit_id FROM operating_transport_metro_exit;

/* Collect exits withour render labels */

INSERT INTO transport_metro_exit_without_render_label
SELECT DISTINCT ft_id FROM ft WHERE ft_type_id = 634 /* transport-metro-exit */
EXCEPT
SELECT DISTINCT ft_id FROM ft_nm WHERE lang IN ('ru', 'en') AND name_type = 1;

/* Insert new render labels for operating exits without render labels */

INSERT INTO ft_nm (nm_id, ft_id, lang, is_local, is_auto, name, name_type)
SELECT NEXTVAL('nm_id_serial'), exit_id, 'ru', FALSE, FALSE, 'выход' || base_name, 1
FROM operating_transport_metro_exit
JOIN transport_metro_exit_without_render_label USING (exit_id)
WHERE is_exit_only;

INSERT INTO ft_nm (nm_id, ft_id, lang, is_local, is_auto, name, name_type)
SELECT NEXTVAL('nm_id_serial'), exit_id, 'ru', FALSE, FALSE, 'вход' || base_name, 1
FROM operating_transport_metro_exit
JOIN transport_metro_exit_without_render_label USING (exit_id)
WHERE NOT is_exit_only;

INSERT INTO ft_nm (nm_id, ft_id, lang, is_local, is_auto, name, name_type)
SELECT NEXTVAL('nm_id_serial'), exit_id, 'en', FALSE, FALSE, 'exit' || base_name, 1
FROM operating_transport_metro_exit
JOIN transport_metro_exit_without_render_label USING (exit_id)
WHERE is_exit_only;

INSERT INTO ft_nm (nm_id, ft_id, lang, is_local, is_auto, name, name_type)
SELECT NEXTVAL('nm_id_serial'), exit_id, 'en', FALSE, FALSE, 'entrance' || base_name, 1
FROM operating_transport_metro_exit
JOIN transport_metro_exit_without_render_label USING (exit_id)
WHERE NOT is_exit_only;

/* Insert new render labels for not-operating exits without render labels */

INSERT INTO ft_nm (nm_id, ft_id, lang, is_local, is_auto, name, name_type)
SELECT NEXTVAL('nm_id_serial'), exit_id, 'ru', FALSE, FALSE, 'вход закрыт', 1
FROM not_operating_transport_metro_exit
JOIN transport_metro_exit_without_render_label USING (exit_id);

INSERT INTO ft_nm (nm_id, ft_id, lang, is_local, is_auto, name, name_type)
SELECT NEXTVAL('nm_id_serial'), exit_id, 'en', FALSE, FALSE, 'entrance closed', 1
FROM not_operating_transport_metro_exit
JOIN transport_metro_exit_without_render_label USING (exit_id);
