/*
The task is to find markings base surface if not set directly.
Base surface is surface with maximum intersection of marking geometry.
At first pass surface with zero zlev is searched.
*/

CREATE TEMPORARY TABLE road_surface_0 AS
SELECT ft_id, ST_BuildArea(ST_Collect(shape)) AS shape
FROM ft
JOIN ft_face USING(ft_id)
JOIN face_edge USING(face_id)
JOIN edge USING(edge_id)
JOIN ft_hd_attr USING(ft_id)
WHERE ft_type_id IN (10010, 10020, 10030, 10040, 10050, 10060, 10070)
    AND min_zlev = 0 AND max_zlev = 0
GROUP BY ft_id;
CREATE INDEX ON road_surface_0 USING gist(shape);

CREATE TEMPORARY TABLE road_surface AS
SELECT ft_id, ST_BuildArea(ST_Collect(shape)) AS shape
FROM ft
JOIN ft_face USING(ft_id)
JOIN face_edge USING(face_id)
JOIN edge USING(edge_id)
WHERE ft_type_id IN (10010, 10020, 10030, 10040, 10050, 10060, 10070)
GROUP BY ft_id;
CREATE INDEX ON road_surface USING gist(shape);

CREATE TEMPORARY TABLE road_marking_polygonal_no_parent AS
SELECT ft_id, ST_BuildArea(ST_Collect(shape)) AS shape, NULL as p_ft_id
FROM ft
JOIN ft_face USING(ft_id)
JOIN face_edge USING(face_id)
JOIN edge USING(edge_id)
WHERE ft_type_id IN (20010, 20020, 20030, 20040, 20050, 20060, 20070, 20080) AND p_ft_id IS NULL
GROUP BY ft_id;
CREATE INDEX ON road_marking_polygonal_no_parent USING btree(ft_id);

/* Zero level pass */

UPDATE ft
SET p_ft_id =
    (SELECT s.ft_id FROM road_marking_polygonal_no_parent pnp, road_surface_0 s WHERE
        ST_Intersects(pnp.shape, s.shape) AND pnp.ft_id = ft.ft_id
        ORDER BY ST_Area(ST_Intersection(pnp.shape, s.shape)) DESC LIMIT 1)
WHERE ft_type_id IN (20010, 20020, 20030, 20040, 20050, 20060, 20070, 20080) AND p_ft_id IS NULL;

UPDATE ft
SET p_ft_id =
    (SELECT s.ft_id FROM ft_edge fe, edge e, road_surface_0 s WHERE
        ST_Intersects(e.shape, s.shape) AND ft.ft_id=fe.ft_id AND fe.edge_id = e.edge_id
        ORDER BY ST_Length(ST_Intersection(e.shape, s.shape)) DESC LIMIT 1)
WHERE ft_type_id IN (30010, 30020, 30030, 30040, 30050, 30060, 30070, 30080, 30090, 30100, 30110, 30120, 30130, 30140, 30150, 30160, 30170, 30180)
AND p_ft_id IS NULL;

UPDATE ft
SET p_ft_id =
    (SELECT s.ft_id FROM node, road_surface_0 s WHERE
        ST_Intersects(node.shape, s.shape) AND ft.ft_id=node.node_id LIMIT 1)
WHERE ft_type_id IN
    (11010, 11011, 11012, 11013, 11014, 11015, 11016, 11017, 11018, 11019, 11020, 11021, 11022, 11031, 11032,
    11033, 11034, 11035, 11036, 11037, 11038, 11074, 11075, 11051, 11052, 11053, 11054, 11055, 11056, 11057,
    11058, 11100, 11101, 11102, 11103, 11104, 11105, 11106, 11107, 11108, 11109, 11110, 11111, 11112, 11113,
    11114, 11115, 11116, 11117, 11118, 11119, 11120, 11121, 11122, 11123, 11124, 11125, 11126, 11127, 11128, 11129, 11000)
AND p_ft_id IS NULL;


/* Any level pass */

UPDATE ft
SET p_ft_id =
    (SELECT s.ft_id FROM road_marking_polygonal_no_parent pnp, road_surface s WHERE
        ST_Intersects(pnp.shape, s.shape) AND pnp.ft_id = ft.ft_id
        ORDER BY ST_Area(ST_Intersection(pnp.shape, s.shape)) DESC LIMIT 1)
WHERE ft_type_id IN (20010, 20020, 20030, 20040, 20050, 20060, 20070, 20080) AND p_ft_id IS NULL;

UPDATE ft
SET p_ft_id =
    (SELECT s.ft_id FROM ft_edge fe, edge e, road_surface s WHERE
        ST_Intersects(e.shape, s.shape) AND ft.ft_id=fe.ft_id AND fe.edge_id = e.edge_id
        ORDER BY ST_Length(ST_Intersection(e.shape, s.shape)) DESC LIMIT 1)
WHERE ft_type_id IN (30010, 30020, 30030, 30040, 30050, 30060, 30070, 30080, 30090, 30100, 30110, 30120, 30130, 30140, 30150, 30160, 30170, 30180)
AND p_ft_id IS NULL;

UPDATE ft
SET p_ft_id =
    (SELECT s.ft_id FROM node, road_surface s WHERE
        ST_Intersects(node.shape, s.shape) AND ft.ft_id=node.node_id LIMIT 1)
WHERE ft_type_id IN
    (11010, 11011, 11012, 11013, 11014, 11015, 11016, 11017, 11018, 11019, 11020, 11021, 11022, 11031, 11032,
    11033, 11034, 11035, 11036, 11037, 11038, 11074, 11075, 11051, 11052, 11053, 11054, 11055, 11056, 11057,
    11058, 11100, 11101, 11102, 11103, 11104, 11105, 11106, 11107, 11108, 11109, 11110, 11111, 11112, 11113,
    11114, 11115, 11116, 11117, 11118, 11119, 11120, 11121, 11122, 11123, 11124, 11125, 11126, 11127, 11128, 11129, 11000)
AND p_ft_id IS NULL;
