CREATE TEMPORARY TABLE indoor_level_plan_universal (
    level_id bigint PRIMARY KEY NOT NULL,
    plan_id bigint NOT NULL,
    universal text NOT NULL
);

INSERT INTO indoor_level_plan_universal(level_id, plan_id, universal)
    SELECT ft.ft_id, p_ft_id, name FROM ft JOIN ft_nm USING (ft_id) WHERE name_type = 6 and ft_type_id IN (2302, 2303);

CREATE TEMPORARY TABLE indoor_level_root (
    level_id bigint,
    root_level_id bigint
);

INSERT INTO indoor_level_root
    SELECT level.level_id, min(same.level_id) as root
        FROM indoor_level_plan_universal level, indoor_level_plan_universal same
        WHERE
            same.plan_id=level.plan_id AND same.universal=level.universal
            GROUP BY same.plan_id, same.universal, level.level_id;

CREATE TABLE delete_levels
(
    level_id bigint
);

INSERT INTO delete_levels SELECT level_id FROM indoor_level_root WHERE level_id <> root_level_id;

UPDATE ft SET p_ft_id = (SELECT root_level_id FROM indoor_level_root WHERE level_id=p_ft_id)
    WHERE p_ft_id IN (SELECT level_id FROM indoor_level_plan_universal);

UPDATE ft_face SET ft_id = (SELECT root_level_id FROM indoor_level_root WHERE level_id=ft_id)
    WHERE ft_id IN (SELECT level_id FROM indoor_level_plan_universal);

DELETE FROM ONLY ft_nm USING delete_levels
    WHERE ft_id = level_id;

DELETE FROM ONLY ft_attr USING delete_levels
    WHERE ft_id = level_id;

DELETE FROM ONLY ft USING delete_levels
    WHERE ft_id = level_id;
