-- Contains points and geometry with `indoor` ft_types
-- pnavigine: HUGE list of ft_types taken from:
-- https://arcanum.yandex-team.ru/arc/trunk/arcadia/maps/wikimap/mapspro/cfg/editor/attributes.xml
-- filter only `indoor points` types
CREATE TEMPORARY TABLE ft_point AS
WITH points AS (
    SELECT ft_id FROM ft_center
    EXCEPT
    SELECT ft_id FROM ft_edge
    EXCEPT
    SELECT ft_id FROM ft_face
)
SELECT ft_id, shape
FROM ft_center
JOIN ft USING(ft_id)
JOIN points USING(ft_id)
JOIN node USING(node_id)
WHERE ft_type_id IN
    (2501, 2502, 2503, 2504, 2505, 2506, 2507, 2508, 2509,
      512, 2005, 2007, 2009, 2601, 2602, 2603, 2604, 2605,
      1402, 1404, 1405, 176, 177, 178, 179, 180, 173, 175,
      1303, 1305, 1306, 1307, 1308, 1309, 1310, 1311,
      1312, 1313, 1314, 1315, 1316, 1317, 1318, 1319, 1320,
      1600, 1601, 1602, 1604, 1605, 1606, 1607, 1608, 1609,
      1610, 1613, 1615, 1617, 1618, 2701, 2702, 2703, 2704,
      2705, 2706, 2707, 2708, 2709, 2710, 2711, 225,  1501,
      1502, 1503, 1505, 1506, 1508, 1000, 172, 181, 1004,
      1005, 165, 164, 222, 223, 227, 229, 232, 224, 1803,
      1805, 2801, 2802, 2803, 2804, 2805, 191, 1701, 1702,
      1707, 1111, 1103, 1113, 1114, 1115);

-- Contains polygonal geometry of indoor levels
CREATE TEMPORARY TABLE indoor_level AS
SELECT ft_id, ST_MakePolygon(shape) AS shape
FROM ft
JOIN ft_face USING(ft_id)
JOIN face_edge USING(face_id)
JOIN edge USING(edge_id)
WHERE ft_type_id IN (2302, 2303)
      AND is_interior = false;

CREATE INDEX ON indoor_level USING gist(shape);

CREATE TEMPORARY TABLE indoor_poi AS
WITH
ft_ft_default_for AS (
    SELECT *
    FROM ft_ft
    WHERE role='default-for'
)
SELECT poi.ft_id, poi.p_ft_id, poi.disp_class,
CASE
    WHEN role='default-for' THEN TRUE
    ELSE FALSE
END AS is_default_level
FROM ft poi
JOIN indoor_level ON poi.p_ft_id=indoor_level.ft_id
JOIN ft_point ON poi.ft_id = ft_point.ft_id
LEFT JOIN ft_ft_default_for ft_ft ON ft_ft.slave_ft_id=poi.p_ft_id;

UPDATE ft
SET disp_class = 8
FROM indoor_poi
WHERE indoor_poi.ft_id = ft.ft_id
      AND indoor_poi.disp_class = 9
      AND is_default_level;

CREATE TEMPORARY TABLE duplicated_poi AS
WITH
non_indoor_poi AS (
    SELECT ft_point.ft_id, shape
    FROM ft_point
    LEFT JOIN indoor_poi USING(ft_id)
    WHERE indoor_poi.ft_id IS NULL
)
SELECT DISTINCT
    poi.ft_id
    FROM non_indoor_poi poi
    JOIN indoor_level
    ON (ST_Intersects(poi.shape, indoor_level.shape));

-- Remove main indoor_plan POIs from list of duplicated_poi
DELETE FROM duplicated_poi dp WHERE EXISTS (SELECT p_ft_id FROM ft WHERE p_ft_id=dp.ft_id AND ft_type_id = 2301);


DELETE FROM ft
USING duplicated_poi
WHERE ft.ft_id = duplicated_poi.ft_id;

UPDATE ft
SET p_ft_id = NULL
FROM duplicated_poi
WHERE ft.p_ft_id = duplicated_poi.ft_id;

DELETE FROM ft_center
USING duplicated_poi
WHERE ft_center.ft_id = duplicated_poi.ft_id;

DELETE FROM ft_ft
USING duplicated_poi
WHERE ft_ft.master_ft_id = duplicated_poi.ft_id;

DELETE FROM ft_nm
USING duplicated_poi
WHERE ft_nm.ft_id = duplicated_poi.ft_id;

DELETE FROM ft_poi_attr
USING duplicated_poi
WHERE ft_poi_attr.ft_id = duplicated_poi.ft_id;

DELETE FROM ft_source
USING duplicated_poi
WHERE ft_source.ft_id = duplicated_poi.ft_id;
