-- All ad with alternative TR subst in AZ + list from NMAPS-13333
CREATE TEMPORARY TABLE karabakh_ad AS
(
    SELECT DISTINCT ad_subst.g_ad_id AS ad_id
    FROM ad AS ad_subst
    JOIN ad_isocode ON ad_isocode.ad_id = ad_subst.g_ad_id
    JOIN ad_recognition AS ad_subst_recognition ON ad_subst_recognition.ad_id = ad_subst.ad_id
    WHERE ad_isocode.isocode = 'AZ'
    AND ad_subst_recognition.isocode IN ('AZ', 'TR')
);
ALTER TABLE karabakh_ad ADD PRIMARY KEY (ad_id);
INSERT INTO karabakh_ad
VALUES
    (772094975), (1508539798), (1508539800), (1508540633), (1508541817), (1508543900), (1508543906), (1508543907),
    (1508543908), (1508543909), (1508543918), (1508543920), (1508543921), (1508543922), (1508543923), (1508543934),
    (1508543936), (1508543937), (1508543938), (1508543939), (1508543940), (1508543941), (1508543942), (1508543943),
    (1508543970), (1508543971), (1508543972), (1508543973), (1508543974), (1508543990), (1508543991), (1508543992),
    (1508543993), (1508543994), (1508544039), (1508544103), (1508544116), (1508544130), (1508544173), (1508544200),
    (1508544202), (1508544203), (1508544218), (1508544283), (1508544284), (1508544285), (1508544287), (1508544288),
    (1508544289), (1508544293), (1508544295), (1508544297), (1508544461), (1508544491), (1508544595), (1508544596),
    (1508544597), (1508544598), (1508544599), (1508544600), (1508544601), (1508544711), (1508544712), (1508544713),
    (1508544714), (1508544715), (1508545198), (1508545745), (1508545746), (1508545747), (1508545753), (1508546324),
    (1508546325), (1508546327), (1508546328), (1508546337), (1508546349), (1508546350), (1508546351), (1508546352),
    (1508546353), (1508546383), (1508546384), (1508546385), (1508546387), (1508546388), (1508546390), (1508546391),
    (1508546392), (1508546393), (1508546395), (1508546397), (1508546399), (1508546402), (1508546740), (1508546741),
    (1508546742), (1508546743), (1508546744), (1508546745), (1508546746), (1508546747), (1508546748), (1508546897),
    (1508546898), (1508546899), (1508546900), (1508546905), (1508546906), (1508546907), (1508546910), (1508546911),
    (1508546912), (1508546913), (1508546914), (1508546915), (1508546916), (1508546917), (1508547528), (1508547580),
    (1508547619), (1508547691), (1508547920), (1508547921), (1508547938), (1508548005), (1508548006), (1508548007),
    (1508548008), (1508548009), (1508548010), (1508548011), (1508548016), (1508548018), (1508548019), (1508548020),
    (1508548021), (1508548042), (1508548086), (1508548088), (1508548101), (1508548102), (1508548103), (1508548104),
    (1508548105), (1508548491), (1508548498), (1508548501), (1508548502), (1508548503), (1508548504), (1508548505),
    (1508548506), (1508548507), (1508548508), (1508548509), (1508548510), (1508548513), (1508548514), (1508548515),
    (1508548516), (1508548519), (1508548522), (1508548523), (1508548524), (1508548525), (1508548532), (1508548545),
    (1508548546), (1508548548), (1508548550), (1508548551), (1508548585), (1508548751), (1508548771), (1508548790),
    (1508548791), (1508548793), (1508548797), (1508548798), (1508548805), (1508548806), (1508548808), (1508548809),
    (1508548857), (1508548858), (1508548875), (1508548876), (1508549076), (1508549077), (1508549078), (1508549119),
    (1508549182), (1508549231), (1508549238), (1508549244), (1508549646), (1508550710), (1508550742), (1508550751),
    (1508550752), (1508550753), (1508550791), (1607706309), (1698649177), (1827334781), (1827356071), (1827451881),
    (1927677601), (1930943661), (1930950161), (1930954101), (1930971191), (1930996101), (1930999571), (1931000871),
    (1931005341), (1931060121), (1941693411), (1949930391), (1949939131), (1951171111), (1951643631), (1961178998),
    (1962927078), (2017457943), (2018370343), (2019358895), (2019417985), (2020091825), (2020105555), (2020120655),
    (2020132455), (2021655685), (2023872805), (2023886245), (2023895455), (2024340945), (2025413995), (2025444605),
    (2026881086), (2027067286), (2027069586), (2027083206), (2027503326), (2027513906), (2027523266), (2027529856),
    (2027557326), (2029197976), (2040094770), (2042425640), (2042445450), (2042549140), (2045934470), (2045951740),
    (2065706814), (2065707924), (2128672035), (2128673635), (2162018592), (2162020622), (2312145442), (2312147152),
    (3124871267), (3124879207), (3124886527), (3124894207), (3124901387), (3124906387), (3124961727), (3124966017),
    (3124968607), (3124970397), (3124971377), (3124971927), (3124973827), (3124974817), (3124976357), (3129315207),
    (3129316577), (3129319967), (3129325367), (3129331407), (3129333647), (3129335017), (3129335967), (3129338227),
    (3129339077), (3129913557), (3129921407), (3298804865), (3298809695), (3385985785), (3871301760), (3871302040),
    (3871302600), (3871303240), (3871303570), (3871303840), (3871304040), (3871305650), (3871306310), (3871307120),
    (3871307970), (3871308510), (3871308840), (3871309080), (3871309800), (3871310240), (3871310830), (3871315400),
    (3871315770), (3871316060), (3871317470), (3992916620), (3992917300), (3992917420), (3992917590), (3992917670),
    (3992918140), (3992921900), (3992921930), (4000090500), (4105948492), (4105971562), (4105983752), (4105985632),
    (4106002792), (4106474342), (4106475152), (4106481222), (4106482402), (4106492352), (4106494712), (4106495212),
    (4106002792), (4106474342), (4106475152), (4106481222), (4106482402), (4106492352), (4106494712), (4106495212),
    (4106496442), (4106501272), (4106503392), (4106504652), (4135674166), (4135674686), (4148540476), (4149297726),
    (4149311016), (4149328236), (4149344726), (4149353276), (4153443196), (4159555616), (4185326713), (4186456293),
    (4187015063), (4190054893), (4195679343), (4195685403), (4195687933), (4195693943), (4195694823), (4195698963),
    (4195700133), (4195700893), (4195701513), (4195704983), (4195709573), (4195710913), (4195711743), (4195712893),
    (4195714983), (4195716123), (4195717223), (4195718193), (4195720403), (4195721093), (4195722083), (4195723323),
    (4195725583), (4195727413), (4195729123), (4195730633), (4195732303), (4195732983), (4195733413), (4195977673),
    (4195979283), (4195983853), (4196378863), (4200615483), (4200618003), (4200621773), (4200624373), (4200649223),
    (4213148313), (4213158503), (4213167553), (4213173143), (4213205853), (4213208803), (4213216953), (4213232233),
    (4213242623), (4213245873), (4213247333), (4213249453), (4213251473), (4213251823), (4213253663), (4213254123),
    (4213255223), (4213257853), (4213258193), (4213258533), (4213259833), (4213262503), (4213263403), (4213265383),
    (4213266573), (4213268283), (4213268463), (4213268673), (4213268893), (4213269143), (4213269473), (4213269893),
    (4213270143), (4213270493), (4213271193), (4213271593), (4213272203), (4213272703), (4213273483), (4213273683),
    (4213274253)
ON CONFLICT DO NOTHING;


CREATE TEMPORARY TABLE karabakh_rd AS
(
    SELECT rd_id FROM rd_ad
    JOIN karabakh_ad USING(ad_id)
);
ALTER TABLE karabakh_rd ADD PRIMARY KEY (rd_id);


-- change uk (label only) and tr (all) names name_type to 4-synonyms
UPDATE rd_nm SET name_type = 4
FROM karabakh_rd
WHERE rd_nm.rd_id = karabakh_rd.rd_id
AND ((lang = 'uk' AND name_type = 1) OR (lang = 'tr' AND name_type != 4));


-- copy best hy name (label, official or any other) to uk-label name
CREATE TEMPORARY SEQUENCE rd_nm_id_seq;
SELECT setval('rd_nm_id_seq', (SELECT max(nm_id) + 1 FROM rd_nm));

INSERT INTO rd_nm (nm_id, rd_id, lang, is_local, is_auto, name_type, name)
SELECT DISTINCT ON (rd_id)
    nextval('rd_nm_id_seq'), rd_id, 'uk', TRUE, FALSE, 1, name
FROM rd_nm
JOIN karabakh_rd USING(rd_id)
WHERE lang = 'hy'
ORDER BY
    rd_id,
    CASE WHEN name_type=1 THEN 0 WHEN name_type=0 THEN 1 ELSE name_type END,
    CASE WHEN script='Latn' THEN 0 ELSE 1 END;


-- move az to tr
UPDATE rd_nm SET is_local = True, lang = 'tr'
FROM karabakh_rd
WHERE rd_nm.rd_id = karabakh_rd.rd_id AND lang = 'az';
