CREATE TEMPORARY TABLE rd_rs_with_sr_latn_nm AS
SELECT DISTINCT rd_id
FROM rd_nm
JOIN rd_isocode USING (rd_id)
WHERE isocode = 'RS'
AND lang = 'sr'
AND script = 'Latn'
AND name_type IN (0 /*official*/, 1 /*label*/);

CREATE UNIQUE INDEX ON rd_rs_with_sr_latn_nm (rd_id);

UPDATE rd_nm
SET name_type = 4 /*synonym*/
FROM rd_rs_with_sr_latn_nm
WHERE rd_rs_with_sr_latn_nm.rd_id = rd_nm.rd_id
AND lang = 'en'
AND name_type IN (0 /*official*/, 1 /*label*/);

UPDATE rd_nm
SET lang = 'en', script = NULL, is_local = FALSE
FROM rd_rs_with_sr_latn_nm
WHERE rd_rs_with_sr_latn_nm.rd_id = rd_nm.rd_id
AND lang = 'sr'
AND script = 'Latn'
AND name_type IN (0 /*official*/, 1 /*label*/);



CREATE TEMPORARY TABLE ad_rs_with_sr_latn_nm AS
SELECT DISTINCT ad_id
FROM ad_nm
JOIN ad_isocode USING (ad_id)
WHERE isocode = 'RS'
AND lang = 'sr'
AND script = 'Latn'
AND name_type IN (0 /*official*/, 1 /*label*/);

CREATE UNIQUE INDEX ON ad_rs_with_sr_latn_nm (ad_id);

UPDATE ad_nm
SET name_type = 4 /*synonym*/
FROM ad_rs_with_sr_latn_nm
WHERE ad_rs_with_sr_latn_nm.ad_id = ad_nm.ad_id
AND lang = 'en'
AND name_type IN (0 /*official*/, 1 /*label*/);

UPDATE ad_nm
SET lang = 'en', script = NULL, is_local = FALSE
FROM ad_rs_with_sr_latn_nm
WHERE ad_rs_with_sr_latn_nm.ad_id = ad_nm.ad_id
AND lang = 'sr'
AND script = 'Latn'
AND name_type IN (0 /*official*/, 1 /*label*/);



CREATE TEMPORARY TABLE addr_rs_with_sr_latn_nm AS
SELECT DISTINCT addr_id
FROM addr_nm
JOIN addr_isocode USING (addr_id)
WHERE isocode = 'RS'
AND lang = 'sr'
AND script = 'Latn'
AND name_type IN (0 /*official*/, 1 /*label*/);

CREATE UNIQUE INDEX ON addr_rs_with_sr_latn_nm (addr_id);

UPDATE addr_nm
SET name_type = 4 /*synonym*/
FROM addr_rs_with_sr_latn_nm
WHERE addr_rs_with_sr_latn_nm.addr_id = addr_nm.addr_id
AND lang = 'en'
AND name_type IN (0 /*official*/, 1 /*label*/);

UPDATE addr_nm
SET lang = 'en', script = NULL, is_local = FALSE
FROM addr_rs_with_sr_latn_nm
WHERE addr_rs_with_sr_latn_nm.addr_id = addr_nm.addr_id
AND lang = 'sr'
AND script = 'Latn'
AND name_type IN (0 /*official*/, 1 /*label*/);



CREATE TEMPORARY TABLE ft_rs_with_sr_latn_nm AS
SELECT DISTINCT ft_id
FROM ft_nm
JOIN ft_isocode USING (ft_id)
WHERE isocode = 'RS'
AND lang = 'sr'
AND script = 'Latn'
AND name_type IN (0 /*official*/, 1 /*label*/);

CREATE UNIQUE INDEX ON ft_rs_with_sr_latn_nm (ft_id);

UPDATE ft_nm
SET name_type = 4 /*synonym*/
FROM ft_rs_with_sr_latn_nm
WHERE ft_rs_with_sr_latn_nm.ft_id = ft_nm.ft_id
AND lang = 'en'
AND name_type IN (0 /*official*/, 1 /*label*/);

UPDATE ft_nm
SET lang = 'en', script = NULL, is_local = FALSE
FROM ft_rs_with_sr_latn_nm
WHERE ft_rs_with_sr_latn_nm.ft_id = ft_nm.ft_id
AND lang = 'sr'
AND script = 'Latn'
AND name_type IN (0 /*official*/, 1 /*label*/);

