CREATE TEMPORARY TABLE vehicle_restriction_area AS
SELECT ft_id, ST_BuildArea(ST_Collect(shape)) AS shape
FROM ft
JOIN ft_face USING(ft_id)
JOIN face_edge USING(face_id)
JOIN edge USING(edge_id)
WHERE ft_type_id=30721
GROUP BY ft_id;

CREATE INDEX IF NOT EXISTS vehicle_restriction_area_shape_idx ON vehicle_restriction_area USING gist(shape);
CREATE INDEX IF NOT EXISTS rd_el_shape_tmp_idx ON rd_el USING gist(shape);

UPDATE rd_el_vehicle_restriction revr
    SET level=1
    WHERE EXISTS
        (SELECT * FROM vehicle_restriction_area v, rd_el g
         WHERE ST_Intersects(g.shape, v.shape) AND g.rd_el_id = revr.rd_el_id);

INSERT INTO rd_el_vehicle_restriction (rd_el_id, vehicle_restriction_id, level, direction)
    SELECT rd_el_id, key::bigint, 0, 'B'
    FROM rd_el, vehicle_restriction_area va, ft_attr
    WHERE ST_Intersects(rd_el.shape, va.shape) AND ft_attr.ft_id = va.ft_id AND ft_attr.value='restriction';

DELETE FROM edge e WHERE EXISTS (SELECT * FROM ft JOIN ft_face USING(ft_id) JOIN face_edge fe USING(face_id) WHERE fe.edge_id = e.edge_id AND ft_type_id = 30721);
DELETE FROM face_edge fe WHERE EXISTS (SELECT * FROM ft JOIN ft_face ff USING(ft_id) WHERE ff.face_id = fe.face_id AND ft_type_id = 30721);
DELETE FROM ft_face ff WHERE EXISTS (SELECT * FROM ft WHERE ft.ft_id=ff.ft_id AND ft_type_id = 30721);
DELETE FROM ft_attr WHERE ft_id IN (SELECT ft_id FROM ft WHERE ft_type_id=30721);
DELETE FROM ft WHERE ft_type_id = 30721;


DROP INDEX IF EXISTS rd_el_shape_tmp_idx;
