#pragma once
#include "config_helper.h"
#include "region.h"
#include "params.h"
#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/tds/schema/relmode.h>
#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/ymapsdf/schema/table.h>
#include <maps/libs/xml/include/xml.h>

namespace maps::wiki::json2ymapsdf::config {

using NodeList = std::list<xml3::Node>;

void init(const Params& params, const ymapsdf::schema::Schema& ymapsdfSchema);
std::string cfgDir();

std::vector<const xml3::Node*> nodes(const tds::schema::Category& category);
std::vector<const xml3::Node*> nodes(const tds::schema::Relation& tdsRelation);
std::vector<const xml3::Node*> nodes(
    const tds::schema::Relation& tdsRelation,
    const ymapsdf::schema::Table& defaultTable);
std::string mainTableName(const tds::schema::Category& category);

bool toSkip(const tds::schema::Category& tdsCategory);
bool toSkip(const tds::schema::Relation& tdsRelation);

const NodeList& fixIncompleteNodes();
const NodeList& fixYmapsdfNodes();
const NodeList& regionNodes();

std::string getPathEditorCfg(const std::string& cfgFile);
std::string getPathSchemaSql(const std::string& cfgFile);
std::string getPathSchemaPubSql(const std::string& cfgFile);
std::string getPathSchemaViewSql(const std::string& cfgFile);
std::string getPathValidationSqlDir(const std::string& cfgFile);

tds::schema::RelationsMode relationsMode(const std::string& cfgFile);

bool disabled(const xml3::Node& node);

const std::string& experiment();

} // namespace maps::wiki::json2ymapsdf::config
