#pragma once

#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/ymapsdf/schema.h>
#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/json2ymapsdf/lib/tds/schema.h>

#include <maps/libs/xml/include/xml.h>

namespace maps::wiki::json2ymapsdf::config {

using CategoryKey = std::string;

std::vector<std::string> getCategories(const xml3::Node& cfgNode);
std::vector<tds::schema::RelationDescriptor> getRelations(const ymapsdf::schema::Schema& ymapsdfSchema, const xml3::Node& cfgNode);

std::vector<std::string> getAttrs(const xml3::Node& cfgNode);

std::string getValue(const xml3::Node& node, const std::string& property);

std::string masterName(const xml3::Node& recordNode);
std::string algorithmName(const xml3::Node& node);
bool skipAlgorithm(const xml3::Node& node);
std::string recordTransformerName(const xml3::Node& recordNode);
std::string fieldTransformerName(const xml3::Node& fieldNode);
std::string tableName(const xml3::Node& recordNode);
std::string mainTableName(const xml3::Node& recordNode);
std::string fieldName(const xml3::Node& fieldNode);
std::string attrName(const xml3::Node& fieldNode);
std::string value(const xml3::Node& fieldNode);
ymapsdf::schema::Type fieldType(const xml3::Node& fieldNode);
const ymapsdf::schema::Table* table(const ymapsdf::schema::Schema& ymapsdfSchema, const xml3::Node& recordNode);
std::string sql(const xml3::Node& node);

xml3::Nodes fieldNodes(const xml3::Node& recordNode);
xml3::Nodes ifNodes(const xml3::Node& recordNode);
bool corresponds(const ymapsdf::schema::Relation& yRel, const xml3::Node* node);

bool allowEmptySetting(const xml3::Node* node);

} // namespace maps::wiki::json2ymapsdf::config
