#pragma once
#include <maps/libs/common/include/exception.h>

#include <util/system/compiler.h>

#include <iostream>
#include <memory>

namespace maps::wiki::json2ymapsdf {

// A replacement for maps::RuntimeError
class TdsDataError: public RuntimeError
{
public:
    TdsDataError() = default;
    explicit TdsDataError(const std::string& what): RuntimeError(what) { }
};

// A replacement for REQUIRE helper
#define DATA_REQUIRE(cond,msg) \
    if (Y_LIKELY(cond)) {} else \
        throw ::maps::wiki::json2ymapsdf::TdsDataError() << msg // NOLINT

} // namespace maps::wiki::json2ymapsdf
