#pragma once

#include <maps/libs/pgpool/include/pgpool3.h>
#include <functional>
#include <string>

namespace maps::wiki::json2ymapsdf {

pqxx::result readWithRetries(
    const std::string& connString,
    const std::string& query);

pqxx::result readWithRetries(
    pgpool3::Pool& pool,
    const std::string& query);

void execCommitWithRetries(
    const std::string& connString,
    const std::string& name,
    const std::string& query,
    const std::function<void(pqxx::transaction_base&)>& f = {});

void execCommitWithRetries(
    pgpool3::Pool& pool,
    const std::string& name,
    const std::string& query,
    const std::function<void(pqxx::transaction_base&)>& f = {});

std::string printScissors(
    const std::string& description,
    const std::string& str);

std::function<void()> safeRunner(
    const std::string& name,
    const std::function<void()>& fail,
    const std::function<void()>& run);

void safeRun(
    const std::string& name,
    const std::function<void()>& fail,
    const std::function<void()>& run);

template <typename T>
struct PtrLess
{
    bool operator() (const T* lhs, const T* rhs) const
    {
        return (lhs == nullptr || rhs == nullptr)
            ? lhs < rhs
            : *lhs < *rhs;
    }
};

} // namespace maps::wiki::json2ymapsdf
