#include "log.h"
#include "params.h"

#include <fstream>

namespace maps::wiki::json2ymapsdf {

namespace {
void nopDeleter(std::ostream*) { }
} // namespace

void
StreamHolder::setOutput(const std::string& fileName)
{
    if (fileName == STDOUT_FILENAME) {
        std::cout.setf(std::ios::unitbuf);
        stream_ = std::shared_ptr<std::ostream>(&std::cout, nopDeleter);
    } else {
        stream_ = std::make_shared<std::ofstream>(fileName);
    }
}

void
StreamHolder::putText(const std::string& text)
{
    if (stream_) {
        *stream_ << text + "\n";
    }
}

namespace dataErrorLog {

StreamHolder& streamHolder()
{
    static StreamHolder streamHolder;
    return streamHolder;
}

void putMessage(const log8::Message& message)
{
    log8::putMessage(message);
    streamHolder().putText(message.text());
}

} // namespace dataErrorLog

namespace ProgressLog {

StreamHolder& streamHolder()
{
    static StreamHolder streamHolder;
    return streamHolder;
}

void putMessage(const log8::Message& message)
{
    log8::putMessage(message);
    streamHolder().putText(message.text());
}

} // namespace ProgressLog

} // namespace maps::wiki::json2ymapsdf
