#pragma once
#include <maps/libs/log8/include/log8.h>
#include <iostream>
#include <memory>

namespace maps::wiki::json2ymapsdf {

using PutFunc = void (&)(const log8::Message &);

template <PutFunc putMessage>
class ErrorHolder : public log8::Message {
public:
    explicit ErrorHolder(log8::Level level)
      : log8::Message(level)
    { }

    ~ErrorHolder()
    {
        putMessage(*this);
    }
};

class StreamHolder {
public:
    void setOutput(const std::string& fileName);
    void putText(const std::string& text);

private:
    std::shared_ptr<std::ostream> stream_;
};


namespace dataErrorLog {

StreamHolder& streamHolder();

void putMessage(const log8::Message& message);

template<typename T>
void
setOutput(T t)
{
    streamHolder().setOutput(t);
}

} // namespace dataErrorLog

namespace ProgressLog {

StreamHolder& streamHolder();

void putMessage(const log8::Message& message);

template<typename T>
void
setOutput(T t)
{
    streamHolder().setOutput(t);
}

} // namespace ProgressLog

using DataErrorHolder = ErrorHolder<dataErrorLog::putMessage>;
using ProgressHolder = ErrorHolder<ProgressLog::putMessage>;

#define DATA_ERROR()  DataErrorHolder(log8::Level::ERROR)
#define PROGRESS()  ProgressHolder(log8::Level::INFO)

} // namespace maps::wiki::json2ymapsdf
